import { UserRepository } from "../../repositories/user/userRepository";

const userRepository = new UserRepository();

export class UserService {
  async createUser(data: any) {
    return await userRepository.createUser(data);
  }

  async getUsers() {
    return await userRepository.getUsers();
  }

  async getUserById(id: string) {
    return await userRepository.getUserById(id);
  }

  async getUserByEmail(email: string) {
    return await userRepository.getUserByEmail(email);
  }

  async updateUser(id: string, data: any) {
    return await userRepository.updateUser(id, data);
  }

  async deleteUser(id: string) {
    return await userRepository.deleteUser(id);
  }
  async restore(id: string) {
    return await userRepository.restore(id);  
  }


  async deleteUserPermanently(id: string) {
    return await userRepository.deleteUserPermanently(id);
  }
  async getInactiveUsers() {
    return await userRepository.getInactiveUsers();
  }

  async getUsersByTeamId(teamId: string) {
    return await userRepository.getUsersByTeamId(teamId);
  }

  async searchUsers(searchTerm: string) {
    return await userRepository.searchUsers(searchTerm);
  }
}
