import dotenv from "dotenv";
import bcrypt from "bcrypt";
import UserRole from "../../interfaces/IUserRole";
import * as UserRepository from "../../repositories/user/userLoginRepository";
import { generateToken } from "../../utils/generateJwt";

// Load environment variables
dotenv.config();

const SECRET_KEY = process.env.JWT_SECRET as string;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET as string;

export const userLogin = async ({
  email,
  password,
}: {
  email: string;
  password: string;
}) => {
  console.log("Email in service", email);
  const user = await UserRepository.getUserByEmail(email);
 
  if(!user) {
    throw{
      status: 404,
      message: "User not found with the given email.",
    };
    }

  if(user.inactive==true) { 
    throw{
      status: 403,
      message: "This account has been deactivated.",
    };
    }




  if (!user.password) throw new Error("User password is missing");
  const passwordMatch = await bcrypt.compare(password, user.password);

  console.log(password, user.password);

  if (!passwordMatch) throw new Error("Invalid credentials");
  console.log(" user details ", user);

  if (!user.teamId) throw new Error("User role is missing");
console.log("user.teamId", user.teamId);

  // Generate access and refresh tokens
  const accessToken = generateToken(
    user.id.toString(),
    user.role as UserRole,
    SECRET_KEY,
    "7d",
    user.teamId,
  );
  const refreshToken = generateToken(
    user.id.toString(),
    user.role as UserRole,
    REFRESH_SECRET,
    "14d",
    user.teamId,
  );

  console.log("Generated Tokens:", { accessToken, refreshToken });

  return { accessToken, refreshToken, user };
};
