import { UserAssessmentRepository } from "../../repositories/user/userAssessmentRepository";
import prisma from "../../config/prismaClient";


export class UserAssessmentService {
    private userAssessmentRepository: UserAssessmentRepository;

    constructor(userAssessmentRepository: UserAssessmentRepository) {
        this.userAssessmentRepository = userAssessmentRepository;
    }

    public async getAllAssessments(userId?: string) {
        try {
            return await this.userAssessmentRepository.getAllAssessments(userId);
        } catch (error) {
            console.error("Error fetching all assessments:", error);
            throw new Error("Failed to retrieve assessments");
        }
    }

    public async getAssessmentById(id: string) {
        try {
            return await this.userAssessmentRepository.getAssessmentById(id);
        } catch (error) {
            console.error("Error fetching assessment by ID:", error);
            throw new Error("Failed to retrieve assessment");
        }
    }
}