import { OperationDashboardRepository } from "../../repositories/user/operationDashboardRepository";

export class OperationDashboardService {
    private operationDashboardRepository: OperationDashboardRepository;

    constructor() {
        this.operationDashboardRepository = new OperationDashboardRepository();
    }

    async getDashboardData(userId: string) { // Add userId parameter
        try {
            const data = await this.operationDashboardRepository.getDashboardData(userId); // Pass userId to repository
            return data;
        } catch (error: any) {
            console.error("Service Error:", error);
            throw new Error("Service failed to fetch Operation dashboard data");
        }
    }
    async getTopBookings(userId: string, limit: number = 5) { // Add userId parameter
        try {
            const data = await this.operationDashboardRepository.getTopBookingsByProfit(userId, limit); // Pass userId to repository
            return data;
        } catch (error: any) {
            console.error("Service Error:", error);
            throw new Error("Failed to fetch Top 5 Bookings");
        }
    }

    async getBookingLeadOverview(timeframe: string = "weekly", userId: string) {
    try {
    const data = await this.operationDashboardRepository.getBookingLeadOverview(timeframe, userId); // Pass userId to repository
    return data;
    } catch (error: any) {
    console.error("Service Error:", error);
    throw new Error("Failed to fetch booking leads data");
    }
    }
}