 import { AssessmentDashboardRepository } from "../../repositories/user/assessmentDashboardRepository";

 export class AssessmentDashboardService {
  private assessmentDashboardRepository: AssessmentDashboardRepository;

  constructor() {
    this.assessmentDashboardRepository = new AssessmentDashboardRepository();
  }

  async getDashboardData(userId: string) {
    try {
      const data = await this.assessmentDashboardRepository.getDashboardData(userId);
      return data;
    } catch (error: any) {
      console.error("Service Error:", error);
        throw new Error("Service failed to fetch Assessment dashboard data");
    }
    }
    async getAssessmentLeadOverview(timeframe: string = "weekly", userId: string) {
        try {
            const data = await this.assessmentDashboardRepository.getAssessmentLeadOverview(timeframe, userId);
            return data;
        } catch (error: any) {
            console.error("Service Error:", error);
            throw new Error("Failed to fetch booking leads data");
        }
    }
       
    
    
}
