// services/UserDashboardService.ts
import { UserTeamDashboardRepository } from "../../repositories/user/UserTeamDashboardRepository";
export class UserDashboardService {
  private dashboardRepository: UserTeamDashboardRepository;

  constructor() {
    this.dashboardRepository = new UserTeamDashboardRepository();
  }

  async getDashboardData(teamId: string, leadPersonEmpCode: string) {
    try {
      return await this.dashboardRepository.getDashboardData(teamId, leadPersonEmpCode);
    } catch (error: any) {
      console.error("Service Error - getDashboardData:", error);
      throw new Error("Service failed to fetch user dashboard data");
    }
  }
}
