import { LeadStage, LeadStatus } from "@prisma/client";
import { Lead } from "../../interfaces/Lead";
import { UserLeadRepository } from "../../repositories/user/userLeadRepository";

export class UserLeadService {
  private userLeadRepository: UserLeadRepository;

  constructor(userLeadRepository: UserLeadRepository) {
    this.userLeadRepository = userLeadRepository;
  }

  public async createLead(leadData: Lead): Promise<Lead> {
    try {
      const newLead = await this.userLeadRepository.createLead(leadData);
      console.log("New lead created:", newLead);

      return newLead;
    } catch (error) {
      console.error("Error creating lead in user service:", error);
      throw error;
    }
  }

  public async getUserLeads(userId: string): Promise<Lead[]> {
    try {
      return await this.userLeadRepository.getUserLeadsByUserId(userId);
    } catch (error) {
      console.error("Error in getUserLeads (service):", error);
      throw error;
    }
  }

  public async getLeadById(leadId: string): Promise<Lead | null> {
    try {
      const lead = await this.userLeadRepository.getLeadById(leadId);
      return lead;
    } catch (error) {
      console.error("Error getting lead by ID in user service:", error);
      throw error;
    }
  }

  public async updateLead(
    leadId: string,
    leadData: Partial<Lead>
  ): Promise<Lead | null> {
    try {
      const updatedLead = await this.userLeadRepository.updateLead(
        leadId,
        leadData
      );
      return updatedLead;
    } catch (error) {
      console.error("Error updating lead in user service:", error);
      throw error;
    }
  }

  public async deleteLead(leadId: string): Promise<void> {
    try {
      await this.userLeadRepository.deleteLead(leadId);
    } catch (error) {
      console.error("Error deleting lead in user service:", error);
      throw error;
    }
  }

  public async changeStatus(id: string, status: LeadStatus): Promise<Lead | null> {
          return await this.userLeadRepository.updateLeadStatus(id, status);
        }
        
        public async changeStage(
          id: string,
          stage: LeadStage,
          userName?: string,
          notes?: string
        ): Promise<Lead | null> {
          return await this.userLeadRepository.updateLeadStage(id, stage, userName, notes);
        }
}
