import { AgentQuotationRepository } from "../../repositories/agent/AgentQuotationRepository";

export class AgentQuotationService {
    private quotationRepository: AgentQuotationRepository;

    constructor(quotationRepository: AgentQuotationRepository) {
        this.quotationRepository = quotationRepository;
    }

    async createQuotation(data: any, agentId: string) {
        try {
            const quotation = await this.quotationRepository.createQuotation(
                data,
                agentId
            );
            console.log("Quotation created in service:", quotation);
            return quotation;
        } catch (error) {
            console.error("Service error while creating quotation:", error);
            throw error;
        }
    }

    async getQuotationById(id: string) {
        try {
            return await this.quotationRepository.getQuotationById(id);
        } catch (error) {
            console.error("Service error:", error);
            throw error;
        }
    }

    async getAllQuotations(agentId: string) {
        try {
            const quotations = await this.quotationRepository.getAllQuotations(
                agentId
            );
            console.log("Quotations fetched successfully:", quotations);
            return quotations;
        } catch (error) {
            console.error("Error in AgentQuotationService.getAllQuotations:", error);
            throw new Error("Failed to fetch quotations");
        }
    }

    async updateQuotation(id: string, data: any) {
        try {
            const response = await this.quotationRepository.updateQuotation(
                id,
                data
            );
            console.log("Response in Service layer update", response);
            return response;
        } catch (error) {
            console.error("Service error updating quotation:", error);
            throw error;
        }
    }

    async deleteQuotation(id: string) {
        try {
            const response = await this.quotationRepository.deleteQuotation(id);
            return response;
        } catch (error) {
            console.error("Service error deleting quotation:", error);
            throw error;
        }
    }
}