// services/DashboardService.ts
import { LeadStage } from "@prisma/client";
import { DashboardRepository } from "../../repositories/admin/dashboardRepository";

const stageLabels = {
  new_lead: "New Leads",
  quotation_created: "Quotation Created",
  quotation_accepted: "Quotation Accepted",
  trip_started: "Trip Started",
  trip_completed: "Trip Completed",
  // Add other stages from your enum here if needed
  canceled: "Canceled",
 
  // etc.
};


export class DashboardService {
  private dashboardRepository: DashboardRepository;

  constructor() {
    this.dashboardRepository = new DashboardRepository();
  }

  async getDashboardData() {
    try {
      const data = await this.dashboardRepository.getDashboardData();
      return data;
    } catch (error: any) {
      console.error("Service Error:", error);
      throw new Error("Service failed to fetch dashboard data");
    }
  }
  async getTopAgents(limit: number = 5) {
    try {
      return await this.dashboardRepository.getTopAgentsByLeadCount(limit);
    } catch (error) {
      console.error("Service Error - getTopAgents:", error);
      throw new Error("Failed to get top agents");
    }
  }
  async getTopSales(limit: number = 5) {
    try {
      return await this.dashboardRepository.getTopSalesByLeadCount(limit);
    } catch (error) {
      console.error("Service Error - getTopSales:", error);
      throw new Error("Failed to get top sales");
    }
  }
  async getLeadFunnelData(period: 'all' | '30d' | '90d') {
    try {
      const counts = await this.dashboardRepository.getLeadStageCounts(period);
      
      // Transform the data from { new_lead: 100 } to [{ label: 'New Leads', count: 100 }, ...]
      const formattedData = Object.entries(counts).map(([stage, count]) => ({
        label: stageLabels[stage as keyof typeof stageLabels] || stage, // Use pretty label, fallback to raw name
        count: count,
      }));

      return formattedData;
    } catch (error) {
      throw new Error("Failed to get lead funnel data.");
    }
  }
}

