import { PrismaClient } from '@prisma/client';


const prisma = new PrismaClient();



export class TourRepository {
   
    async getTours() {
        return await prisma.tour.findMany({
            include: {
                Suppliers: true,
                TourPrice: true,
            },
        });
    }

    async getTourById(id: string) {
        return await prisma.tour.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                TourPrice: true,
            },
        });
    }

   
}