import prisma from "../../config/prismaClient";


export const getUserByEmail = async (email: string) => {
  if (!email) {
    throw new Error("Email is required to find the user");
  }

  return await prisma.user.findUnique({
    where: { email },
    include: { team: true }, // Fetch team details
  });
};
