import { PrismaClient } from '@prisma/client';


const prisma = new PrismaClient();

export class GuideRepository {
    

    async getGuides() {
        return await prisma.guide.findMany({
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }

    async getGuideById(id: string) {
        return await prisma.guide.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }

}