import prisma from "../../config/prismaClient";

export class UserAssessmentRepository {
 
                    
//   async getUserAssessmentById(assessmentId: string): Promise<Assessment | null> {
//     try {
//       const assessment: Assessment | null = await prisma.assessment.findUnique({
//         where: { id: assessmentId },
//       });
//       return assessment;
//     } catch (error) {
//       console.error("Error fetching user assessment by ID:", error);
//       throw new Error("Failed to fetch user assessment by ID");
//     }
//   }
    async getAllAssessments(userId?: string) {
        try {
            const whereClause: any = {};

            if (userId) {
                whereClause.lead = {
                    assignedAssessmentId: userId,
                };
            }

            return await prisma.booking.findMany({
                where: whereClause,
                include: {
                    accommodations: {
                        include: { priceDetailsAccommodation: true },
                    },
                    itineraries: {
                        include: { priceDetailsList: true },
                    },
                    lead: true,
                },
                orderBy: {
                    updatedAt: 'desc',
                },
            });
        } catch (error) {
            console.error("Error fetching all bookings:", error);
            throw new Error("Failed to retrieve bookings");
        }
    }
    async getAssessmentById(id: string) {
        try {
            const assessment = await prisma.booking.findUnique({
                where: { id },
                include: {
                    accommodations: {
                        include: { priceDetailsAccommodation: true },
                    },
                    itineraries: {
                        include: { priceDetailsList: true },
                    },
                    lead: {
                        include: {
                            Agent: true, // Note: Capital 'A' to match your schema
                        },
                    },
                },
            });

            if (!assessment) {
                throw new Error("Assessment not found");
            }
            console.log("Assessment in repo", assessment);
            return assessment;
        } catch (error) {
            console.error("Error fetching Assessment:", error);
            throw new Error("Failed to retrieve assessment");
        }
    }
   



  
  
}