// backend/src/repositories/AgentLoginRepository.ts

import prisma from "../../config/prismaClient";

export class AgentLoginRepository {
  async getAgentByUsername(username: string) {
    if (!username) {
      console.warn("⚠️ getAgentByUsername called with null/empty username.");
      return null;
    }

    const normalizedUsername = username.trim().toLowerCase();

    try {
      const credentials = await prisma.agentCredentials.findFirst({
        where: { username: normalizedUsername },
        include: { agent: true },
      });

      console.log("📦 Agent credentials in repo:", credentials);

      if (!credentials) {
        console.log(
          `❌ No agent credentials found for username: ${normalizedUsername}`
        );
        return null;
      }

      if (!credentials.agent) {
        console.warn(
          `⚠️ Agent found but linked agent entity is null for username: ${normalizedUsername}`
        );
        // You can choose to return credentials here or null based on business logic
        // return null; // <-- uncomment this if agent being null is a hard error
      }

      return credentials;
    } catch (error) {
      console.error(
        `❗ Error fetching credentials by username ${normalizedUsername}:`,
        error
      );
      throw error;
    }
  }
}
