import { NextFunction, Request, Response } from "express";

// 👇 Extend the Request type locally in this file
interface CustomRequest extends Request {
  currentUserRole?: string;
}

export const authorizeRole = (allowedRoles: string[]) => {
  return (req: CustomRequest, res: Response, next: NextFunction): void => {
    console.log("🔍 Checking Role:", req.currentUserRole);
    console.log("🔍 Allowed Roles:", allowedRoles);

    if (!req.currentUserRole || !allowedRoles.includes(req.currentUserRole)) {
      console.error("❌ Access Denied. Current Role:", req.currentUserRole);
      res.status(403).json({
        success: false,
        message: "Access denied: Insufficient permissions",
      });
      return;
    }

    console.log("✅ Role Authorized:", req.currentUserRole);
    next();
  };
};
