import { Supplier } from "./Supplier";

export interface Room {
  id?: string; // Optional, since Prisma auto-generates it
  hotelId: string; // Foreign key to Hotels (required)
  hotel?: Hotel; // Optional relation
  category?: string;
  pax?: number;
  costPrice?: number;
  optionalPrice?: number;
  pricePerNight?: number;
  extraBedAdult?: number;
  extraBedChild?: number;
  breakfastAdult?: number;
  breakfastChild?: number;
  surcharge?: number;
  maxPax?: number;
  extraBeds?: number;
}

export interface HotelPrice {
  id?: string; // Auto-generated
  hotelId: string; // Required foreign key
  hotel?: Hotel; // Optional relation
  category?: string;
  pax?: string;
  costPrice?: number;
  optionalPrice?: number;
}

export interface Hotel {
  id?: string; // Auto-generated
  name: string;  
  location?: string; // Optional
  starRating?: string;
  tourismTax?: string;
  stateTax?: string;
  address?: string;
  phone?: string;
  description?: string;
  termsAndConditions?: string;
  supplierId: string;
  supplier?: Supplier; // Relation to supplier
  rooms?: Room[]; // Associated rooms
  price?: HotelPrice[]; // Linked prices
  surcharge?: Record<string, any>;
  closedDates?: Record<string, any>;
}
