// backend/src/interfaces/Agent.ts

// Interface for the related Credentials model
export interface AgentCredentials {
    id: string; // Primary Key
    username?: string | null;
    password?: string | null; // Will store the HASHED password
    filename?: string | null; // For profile picture
    // agentId?: string | null; // Foreign key linking back (optional if using relation object)
}

// Interface for the main Agent model
export interface Agent {
    agentInfo?: any; // Make agentInfo optional (add ?)
    id: string; // Primary Key
    agentCode?: string | null;
    companyName?: string | null;
    contactPerson?: string | null;
    designation?: string | null;
    companyAddress?: string | null;
    state?: string | null;
    email: string | null;  // Allow email to be null
    phone?: string | null;
    markup?: number | null;
    agentPrivilege?: boolean | null;
    credentialsId?: string | null; // Foreign Key to AgentCredentials
    createdAt?: Date | string | null; // Prisma returns Date, but allow string for flexibility
    updatedAt?: Date | string | null; // Prisma returns Date, but allow string for flexibility
    deleted?: boolean | null; // <-- **** ADD THIS LINE ****

    // Optional: Include the related credentials object if you fetch it frequently
    credentials?: AgentCredentials | null;
}