import { Request, Response, NextFunction } from 'express';  // Import NextFunction
import { TourService } from '../../services/user/userTourService';


const tourService = new TourService();

export class TourController {

    async getTours(req: Request, res: Response, next: NextFunction) {
        try {
            const tours = await tourService.getTours();
            res.json(tours);
        } catch (error: any) {
            next(error); // Pass the error to the next middleware
        }
    }

    async getTourById(req: Request, res: Response, next: NextFunction) {
        try {
            const tour = await tourService.getTourById(req.params.id);
            if (!tour) {
                //Use return statement because is not error
                return res.status(404).json({ message: 'Tour not found' });
            }
            res.json(tour);
        } catch (error: any) {
            next(error); // Pass the error to the next middleware
        }
    }

    
}