import { NextFunction, Request, Response } from "express";
import * as userService from "../../services/user/userLoginService";

export const userLogin = async (
  req: Request,
  res: Response,
  next: NextFunction
): Promise<void> => {
  try {
    const { email, password } = req.body;
    console.log(req.body, "User in controller");

    if (!email || !password) {
       res.status(400).json({
        success: false,
        message: "Email and password are required",
      });
      return;
    }

    const { accessToken, refreshToken, user } = await userService.userLogin({
      email,
      password,
    });

    console.log("User Login Successful:", { email, accessToken, user });

    // ✅ Set Tokens in Response Headers
    res.setHeader("x-access-token", accessToken);
    res.setHeader("x-refresh-token", refreshToken);

    // ✅ Send JSON Response (Returning All Fields)
    res.status(200).json({
      success: true,
      message: "User login successful",
      user: {
        id: user.id,
        name: user.name,
        email: user.email,
        mobile: user.mobile,
        empCode: user.empCode,
        empId: user.empId,
        teamId: user.teamId,
        teamName:user.team?.name,
        agentPrivilege: user.agentPrivilege,
        inactive: user.inactive,
        createdAt: user.createdAt,
        updatedAt: user.updatedAt,
        role: user.role,
      },
      accessToken,
      refreshToken,
    });
  } catch (error:any) {
    console.error("❌ Error in userLogin controller:", error);
    next(error); // ✅ Properly pass errors to Express error handler
  }
};
