import { Request, Response, NextFunction } from "express";
import { GuideService } from "../../services/user/userGuideService";


const guideService = new GuideService();

export class GuideController {
    async getGuides(req: Request, res: Response,next : NextFunction) {
        try {
            const guides = await guideService.getGuides();
            res.json(guides);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
             next(error);
        }
    }

    async getGuideById(req: Request, res: Response,next:NextFunction) {
        try {
            const guide = await guideService.getGuideById(req.params.id);
            if (!guide) {
                res.status(404).json({ message: "Guide not found" });
                return;
            }
            res.json(guide);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
            next(error)
        }
    }

    
}