import { Request, Response } from "express";
import { UserAssessmentService } from "../../services/user/userAssessmentService";


export class UserAssessmentController {
    private userAssessmentService: UserAssessmentService;

    constructor(userAssessmentService: UserAssessmentService) {
        this.userAssessmentService = userAssessmentService;
    }

    public async getAllAssessments(req: Request, res: Response) {
        try {
            const userId = (req as any).currentUser; // Get user ID from authentication middleware
            const assessments = await this.userAssessmentService.getAllAssessments(userId);
            return  res.status(200).json(assessments || []);
        } catch (error) {
            console.error("Error fetching assessments:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    }

    public async getAssessmentById(req: Request, res: Response) {
        try {
            const { id } = req.params;
            const assessment = await this.userAssessmentService.getAssessmentById(id);
          return res.status(200).json(assessment || []);
        } catch (error) {
            console.error("Error fetching assessment by ID:", error);
            res.status(500).json({ error: "Internal Server Error" });
        }
    }
}