import { Request, Response } from "express";
import { OperationDashboardService } from "../../services/user/operationDashboardService";

const operationDashboardService = new OperationDashboardService();

export const getOperationDashboardData = async (req: Request, res: Response) => {
    try {
        const userId = (req as any).currentUser;  // Get user ID from authentication middleware

        const dashboardData = await operationDashboardService.getDashboardData(userId);
        res.status(200).json({ success: true, data: dashboardData});
    } catch (error: any) {
        console.error("Controller Error - getOperationDashboardData:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};

export const getTop5Bookings = async (req: Request, res: Response) => {
    try {
        const userId = (req as any).currentUser;  // Get user ID from authentication middleware

        const topBookings = await operationDashboardService.getTopBookings(userId);
        res.status(200).json({ success: true, data: topBookings });
    } catch (error: any) {
        console.error("Controller Error - getTop5Bookings:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};

export const getBookingLeadOverview = async (req: Request, res: Response) => {
    try {
        const timeframe = (req.params.timeframe as string) || "weekly";
        const userId = (req as any).currentUser;  // Get user ID from authentication middleware

        const bookingLeadOverviewData = await operationDashboardService.getBookingLeadOverview(timeframe, userId);
        res.status(200).json({ success: true, data: bookingLeadOverviewData });
    } catch (error: any) {
        console.error("Controller Error - getBookingLeadOverview:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};