// controllers/common/notification.controller.ts
import { Request, Response } from "express";
import { NotificationService } from "../../services/common/notificationService";

const notificationService = new NotificationService();

export const getAdminNotifications = async (req: Request, res: Response) => {
  try {
    const notifications = await notificationService.getAdminNotifications();
    res.json(notifications);
  } catch (error) {
    console.error("Error fetching admin notifications:", error);
    res.status(500).json({ message: "Failed to fetch notifications" });
  }
}

 export const getUserNotifications = async (req: Request, res: Response) => {
  try { 
     const userId = req.decoded?.userId as string; // Assuming user ID is passed as a URL parameter
    const notifications = await notificationService.getUserNotifications(userId);
    res.json(notifications);
  } catch (error) {
    console.error("Error fetching user notifications:", error);
    res.status(500).json({ message: "Failed to fetch user notifications" });
  }

}



  export const markAllNotificationsAsRead = async (req: Request, res: Response) => {
    try {
      const notification = await notificationService.markAllAsReadForAdmin();
      res.json(notification);
    } catch (error) {
      console.error("Error marking all notifications as read:", error);
      res.status(500).json({ message: "Failed to mark all notifications as read" });
    }
  }

  export const markNotificationAsRead = async (req: Request, res: Response) => {
    try {
      const notification = await notificationService.markAsRead(req.params.id);
      res.json(notification);
    } catch (error) {
      console.error("Error marking notification as read:", error);
      res.status(500).json({ message: "Failed to mark notification as read" });
    }
  };