import dotenv from "dotenv";
import { NextFunction, Request, Response } from "express";
import jwt from "jsonwebtoken";
dotenv.config();

const SECRET_KEY = process.env.JWT_SECRET!;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET!;

export const refreshAccessToken = async (
  req: Request,
  res: Response,
  next: NextFunction
): Promise<void> => {
  try {
    const refreshToken = req.headers["x-refresh-token"] as string;

    if (!refreshToken) {
      res
        .status(401)
        .json({ success: false, message: "Refresh token missing" });
      return;
    }

    const payload = jwt.verify(refreshToken, REFRESH_SECRET);

    if (typeof payload !== "object" || payload === null) {
      throw new Error("Invalid token payload");
    }

    // You can validate payload.id
    const newAccessToken = jwt.sign({ id: payload.id }, SECRET_KEY, {
      expiresIn: "7d",
    });
    res.setHeader("x-access-token", newAccessToken);

    res.status(200).json({
      success: true,
      message: "Access token refreshed",
      accessToken: newAccessToken,
    });
  } catch (error) {
    console.error("Refresh Token Error:", error);
    res
      .status(403)
      .json({ success: false, message: "Invalid or expired refresh token" });
  }
};
