import { Request, Response } from "express";
import { TransferService } from "../../services/admin/transferService";


const transferService = new TransferService();

export class TransferController {
  async createTransfer(req: Request, res: Response) {
    try {
      const transfer = await transferService.createTransfer(req.body);
      res.status(201).json(transfer);
    } catch (error: unknown) {
      if (error instanceof Error) {
        res.status(500).json({ message: error.message });
      } else {
        res.status(500).json({ message: "An unknown error occurred" });
      }
    }
  }

  async getTransfers(req: Request, res: Response) {
    try {
      const transfers = await transferService.getTransfers();
      res.json(transfers);
    } catch (error: unknown) {
      if (error instanceof Error) {
        res.status(500).json({ message: error.message });
      } else {
        res.status(500).json({ message: "An unknown error occurred" });
      }
    }
  }

  async getTransferById(req: Request, res: Response) {
    try {
      const transfer = await transferService.getTransferById(req.params.id);
      if (!transfer) {
        res.status(404).json({ message: "Transfer not found" });
        return;
      }
      res.json(transfer);
    } catch (error: unknown) {
      if (error instanceof Error) {
        res.status(500).json({ message: error.message });
      } else {
        res.status(500).json({ message: "An unknown error occurred" });
      }
    }
  }

  async updateTransfer(req: Request, res: Response) {
    try {
      const transfer = await transferService.updateTransfer(req.params.id, req.body);
      res.json(transfer);
    } catch (error: unknown) {
      if (error instanceof Error) {
        res.status(500).json({ message: error.message });
      } else {
        res.status(500).json({ message: "An unknown error occurred" });
      }
    }
  }

  async deleteTransfer(req: Request, res: Response) {
    try {
      await transferService.deleteTransfer(req.params.id);
      res.json({ message: "Transfer deleted successfully" });
    } catch (error: unknown) {
      if (error instanceof Error) {
        res.status(500).json({ message: error.message });
      } else {
        res.status(500).json({ message: "An unknown error occurred" });
      }
    }
  }
}
