// import { RestaurantService } from "../services/restaurantService";
import { Request, Response } from "express";
import { RestaurantService } from "../../services/admin/restaurantService";


const restaurantService = new RestaurantService();

export class RestaurantController {
  async createRestaurant(req: Request, res: Response) {
    try {
      const restaurant = await restaurantService.createRestaurant(req.body);
      res.status(201).json(restaurant);
    } catch (error: any) {
      console.error("Error creating restaurant:", error);
      res.status(500).json({ error: error.message });
    }
  }

  async getRestaurants(req: Request, res: Response) {
    try {
      const restaurants = await restaurantService.getRestaurants();
      res.json(restaurants);
    } catch (error: any) {
      console.error("Error getting restaurants:", error);
      res.status(500).json({ error: error.message });
    }
  }

  async getRestaurantById(req: Request, res: Response) {
    try {
      const { id } = req.params;
      const restaurant = await restaurantService.getRestaurantById(id);
      if (!restaurant) {
        return res.status(404).json({ message: "Restaurant not found" });
      }
      res.json(restaurant);
    } catch (error: any) {
      console.error("Error getting restaurant:", error);
      res.status(500).json({ error: error.message });
    }
  }

  async updateRestaurant(req: Request, res: Response) {
    try {
      const { id } = req.params;
      const restaurant = await restaurantService.updateRestaurant(id, req.body);
      res.json(restaurant);
    } catch (error: any) {
      console.error("Error updating restaurant:", error);
      res.status(500).json({ error: error.message });
    }
  }

  async deleteRestaurant(req: Request, res: Response) {
    try {
      const { id } = req.params;
      await restaurantService.deleteRestaurant(id);
      res.status(204).send(); // No content
    } catch (error: any) {
      console.error("Error deleting restaurant:", error);
      res.status(500).json({ error: error.message });
    }
  }
}
