// server/src/controllers/admin/guideController.ts
import { Request, Response } from "express";
import { GuideService } from "../../services/admin/guideService";

const guideService = new GuideService();

export class GuideController {
    async createGuide(req: Request, res: Response) {
        try {
            const guide = await guideService.createGuide(req.body);
            res.status(201).json(guide);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }

    async getGuides(req: Request, res: Response) {
        try {
            const guides = await guideService.getGuides();
            res.json(guides);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }

    async getGuideById(req: Request, res: Response) {
        try {
            const guide = await guideService.getGuideById(req.params.id);
            if (!guide) {
                res.status(404).json({ message: "Guide not found" });
                return;
            }
            res.json(guide);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }

    async updateGuide(req: Request, res: Response) {
        try {
            const guide = await guideService.updateGuide(req.params.id, req.body);
            res.json(guide);
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }

    async deleteGuide(req: Request, res: Response) {
        try {
            await guideService.deleteGuide(req.params.id);
            res.json({ message: "Guide deleted successfully" });
        } catch (error: unknown) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            } else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
}