// controllers/dashboard.controller.ts
import { Request, Response } from "express";
import { DashboardService } from "../../services/admin/dashboardService";


const dashboardService = new DashboardService();

export const getDashboardData = async (req: Request, res: Response) => {
  try {
    const dashboardData = await dashboardService.getDashboardData();
    res.status(200).json({ success: true, data: dashboardData });
  } catch (error: any) {
    console.error("Controller Error - getDashboardData:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Internal Server Error",
    });
  }
};

// Add this handler to your dashboard controller
export const getTopAgents = async (req: Request, res: Response) => {
  try {
    const limit = parseInt(req.query.limit as string) || 5;
    const data = await dashboardService.getTopAgents(limit);
    res.status(200).json({
      success: true,
      data,
    });
  } catch (error: any) {
    console.error("Controller Error - getTopAgents:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Failed to fetch top agents",
    });
  }
};
export const getTopSales = async (req: Request, res: Response) => {
  try {
    const limit = parseInt(req.query.limit as string) || 5;
    const data = await dashboardService.getTopSales(limit);
    res.status(200).json({
      success: true,
      data,
    });
  } catch (error: any) {
    console.error("Controller Error - getTopSales:", error);
    res.status(500).json({
      success: false,
      message: error.message || "Failed to fetch top sales",
    });
  }
};

export const getLeadFunnel = async (
  req: Request,
  res: Response,
) => {
  try {
    // Validate query parameter
    const period = req.query.period;
    let validPeriod: 'all' | '30d' | '90d' = 'all'; // Default value
    if (period === '30d' || period === '90d') {
      validPeriod = period;
    }
    
    const data = await dashboardService.getLeadFunnelData(validPeriod);

    res.status(200).json(data);
  } catch (error:any) {
    console.log(error); // Pass to global error handler
    res.status(500).json({
      success: false,
      message: error.message || "Failed to fetch lead funnel data",
    });
  }
  
};

