// backend/src/config/cloudStorageDocument.ts

import { Client } from 'ssh2';
import fs from 'fs';
import path from 'path';

const cloudConfigDocument = {
    host: process.env.SSCLOUD_HOST || 'sscloud.sixthstar.org', // Use env variable
    port: parseInt(process.env.SSCLOUD_PORT || '3263', 10), // Use env variable
    username: process.env.SSCLOUD_USER || 'ftpuser', // Use env variable
    password: process.env.SSCLOUD_PASSWORD || 'Yf_8jGFSr%64,pNm', // Use env variable
    remoteBasePath: '/var/www/html/nextcloud/webim/customer-documents/', // Corrected remote base path for document
    baseUrl: 'https://sscloud.sixthstar.org/webim/customer-documents/', // Corrected base URL for documents
  };

async function uploadToCloudDocument(localFilePath: string, remoteFileName: string): Promise<void> {
  return new Promise((resolve, reject) => {
      const conn = new Client();
      conn.on('ready', () => {
          console.log('Client :: ready');
          conn.sftp((err: any, sftp: { fastPut: (arg0: string, arg1: string, arg2: {}, arg3: (uploadError: any) => void) => void; }) => {
              if (err) {
                  console.error("SFTP Connection Error:", err);
                  reject(err);
                  return;
              }

              const remoteFilePath = cloudConfigDocument.remoteBasePath + remoteFileName;

              sftp.fastPut(localFilePath, remoteFilePath, {}, (uploadError: any) => {
                  if (uploadError) {
                      console.error("SFTP Upload Error:", uploadError);
                      reject(uploadError);
                  } else {
                      console.log('File transferred successfully to ' + remoteFilePath);
                      resolve();
                  }
                  conn.end();
              });
          });
      }).on('error', (err: any) => {
          console.error("SSH Connection Error:", err);
          reject(err);
      }).on('end', () => {
          console.log('Client :: closed');
      }).connect({
          host: cloudConfigDocument.host,
          port: cloudConfigDocument.port,
          username: cloudConfigDocument.username,
          password: cloudConfigDocument.password
      });
  });
}

export { cloudConfigDocument, uploadToCloudDocument };