
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
  skip
} = require('@prisma/client/runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.5.0
 * Query Engine version: 173f8d54f8d52e692c7e27e72a88314ec7aeff60
 */
Prisma.prismaVersion = {
  client: "6.5.0",
  engine: "173f8d54f8d52e692c7e27e72a88314ec7aeff60"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}



/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.AdminScalarFieldEnum = {
  id: 'id',
  name: 'name',
  email: 'email',
  password: 'password',
  role: 'role'
};

exports.Prisma.SuppliersScalarFieldEnum = {
  id: 'id',
  companyName: 'companyName',
  category: 'category',
  contactPerson: 'contactPerson',
  designation: 'designation',
  email: 'email',
  contactNo: 'contactNo',
  companyAddress: 'companyAddress'
};

exports.Prisma.HotelsScalarFieldEnum = {
  id: 'id',
  name: 'name',
  location: 'location',
  starRating: 'starRating',
  tourismTax: 'tourismTax',
  stateTax: 'stateTax',
  address: 'address',
  phone: 'phone',
  description: 'description',
  termsAndConditions: 'termsAndConditions',
  supplierId: 'supplierId',
  surcharge: 'surcharge',
  closedDates: 'closedDates',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.RoomScalarFieldEnum = {
  id: 'id',
  hotelId: 'hotelId',
  maxPax: 'maxPax',
  extraBeds: 'extraBeds',
  name: 'name'
};

exports.Prisma.RoomPriceScalarFieldEnum = {
  id: 'id',
  roomId: 'roomId',
  category: 'category',
  pax: 'pax',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice'
};

exports.Prisma.HotelPriceScalarFieldEnum = {
  id: 'id',
  hotelId: 'hotelId',
  category: 'category',
  pax: 'pax',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice'
};

exports.Prisma.VehicleScalarFieldEnum = {
  id: 'id',
  transferId: 'transferId',
  vehicle: 'vehicle',
  pax: 'pax',
  price: 'price',
  optionalPrice: 'optionalPrice',
  minPax: 'minPax',
  maxPax: 'maxPax'
};

exports.Prisma.TransferScalarFieldEnum = {
  id: 'id',
  name: 'name',
  from: 'from',
  to: 'to',
  supplierId: 'supplierId',
  terms: 'terms',
  updatedAt: 'updatedAt'
};

exports.Prisma.AttractionScalarFieldEnum = {
  id: 'id',
  supplierId: 'supplierId',
  name: 'name',
  location: 'location',
  description: 'description',
  terms: 'terms',
  surchargeDates: 'surchargeDates',
  closedDates: 'closedDates',
  applyFridays: 'applyFridays',
  applySaturdays: 'applySaturdays',
  applySundays: 'applySundays',
  updatedAt: 'updatedAt'
};

exports.Prisma.AttractionPriceScalarFieldEnum = {
  id: 'id',
  category: 'category',
  paxType: 'paxType',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice',
  attractionId: 'attractionId'
};

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  name: 'name',
  email: 'email',
  mobile: 'mobile',
  password: 'password',
  empCode: 'empCode',
  empId: 'empId',
  teamId: 'teamId',
  agentPrivilege: 'agentPrivilege',
  inactive: 'inactive',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  role: 'role'
};

exports.Prisma.TeamScalarFieldEnum = {
  id: 'id',
  name: 'name'
};

exports.Prisma.AgentCredentialsScalarFieldEnum = {
  id: 'id',
  username: 'username',
  password: 'password',
  filename: 'filename'
};

exports.Prisma.AgentScalarFieldEnum = {
  id: 'id',
  agentCode: 'agentCode',
  companyName: 'companyName',
  contactPerson: 'contactPerson',
  designation: 'designation',
  companyAddress: 'companyAddress',
  state: 'state',
  email: 'email',
  phone: 'phone',
  markup: 'markup',
  agentPrivilege: 'agentPrivilege',
  credentialsId: 'credentialsId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  deleted: 'deleted',
  role: 'role'
};

exports.Prisma.LeadScalarFieldEnum = {
  id: 'id',
  empCode: 'empCode',
  agentName: 'agentName',
  agentCode: 'agentCode',
  leadNo: 'leadNo',
  travelDateFrom: 'travelDateFrom',
  travelDateTo: 'travelDateTo',
  totalPax: 'totalPax',
  createdOn: 'createdOn',
  description: 'description',
  customerName: 'customerName',
  email: 'email',
  phone: 'phone',
  adults: 'adults',
  kids: 'kids',
  infants: 'infants',
  remarks: 'remarks',
  agentId: 'agentId',
  stage: 'stage',
  status: 'status',
  statusUpdated: 'statusUpdated',
  updatedAt: 'updatedAt',
  assignedToId: 'assignedToId',
  userId: 'userId',
  assignedOperationId: 'assignedOperationId',
  assignedAssessmentId: 'assignedAssessmentId',
  assignedAssessmentOn: 'assignedAssessmentOn',
  assignedOperationOn: 'assignedOperationOn'
};

exports.Prisma.FollowUpScalarFieldEnum = {
  id: 'id',
  date: 'date',
  oldStage: 'oldStage',
  newStage: 'newStage',
  notes: 'notes',
  leadId: 'leadId',
  userName: 'userName'
};

exports.Prisma.RestaurantScalarFieldEnum = {
  id: 'id',
  name: 'name',
  location: 'location',
  targetMarket: 'targetMarket',
  description: 'description',
  termsAndConditions: 'termsAndConditions',
  updatedAt: 'updatedAt',
  supplierId: 'supplierId'
};

exports.Prisma.MealPriceScalarFieldEnum = {
  id: 'id',
  category: 'category',
  pax: 'pax',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice',
  restaurantId: 'restaurantId'
};

exports.Prisma.PackageScalarFieldEnum = {
  id: 'id',
  packageName: 'packageName',
  tagLine: 'tagLine',
  briefDescription: 'briefDescription',
  detailedDescription: 'detailedDescription',
  terms: 'terms',
  notes: 'notes',
  remarks: 'remarks',
  imageUrl: 'imageUrl',
  starRating: 'starRating',
  price: 'price',
  hotel: 'hotel',
  daysNights: 'daysNights',
  members: 'members',
  deleted: 'deleted',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  hotelId: 'hotelId'
};

exports.Prisma.QuotationScalarFieldEnum = {
  id: 'id',
  refNo: 'refNo',
  leadAgent: 'leadAgent',
  guestName: 'guestName',
  remarks: 'remarks',
  currency: 'currency',
  totalPax: 'totalPax',
  travelDates: 'travelDates',
  updatedAt: 'updatedAt',
  leadRefNo: 'leadRefNo',
  totalAfterMarkup: 'totalAfterMarkup',
  totalBeforeMarkup: 'totalBeforeMarkup',
  userid: 'userid',
  agentId: 'agentId',
  status: 'status',
  currencyRate: 'currencyRate',
  termsAndConditions: 'termsAndConditions',
  importantNotes: 'importantNotes'
};

exports.Prisma.AccommodationScalarFieldEnum = {
  id: 'id',
  quotationId: 'quotationId',
  hotel: 'hotel',
  room: 'room',
  travelDate: 'travelDate',
  endDate: 'endDate',
  nights: 'nights',
  quantity: 'quantity',
  totalPrice: 'totalPrice',
  createdAt: 'createdAt',
  priceDetails: 'priceDetails',
  updatedAt: 'updatedAt',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup',
  surchargeNights: 'surchargeNights',
  supplierContact: 'supplierContact',
  supplierId: 'supplierId',
  supplierName: 'supplierName',
  hotelAddress: 'hotelAddress',
  accMarkup: 'accMarkup'
};

exports.Prisma.ItineraryScalarFieldEnum = {
  id: 'id',
  quotationId: 'quotationId',
  date: 'date',
  label: 'label',
  category: 'category',
  priceDetails: 'priceDetails',
  guideId: 'guideId',
  supplierContact: 'supplierContact',
  supplierId: 'supplierId',
  supplierName: 'supplierName',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup',
  itinMarkup: 'itinMarkup'
};

exports.Prisma.PriceDetailItineraryScalarFieldEnum = {
  id: 'id',
  itineraryId: 'itineraryId',
  category: 'category',
  price: 'price',
  priceAfterMarkup: 'priceAfterMarkup',
  quantity: 'quantity',
  totalPrice: 'totalPrice',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup'
};

exports.Prisma.PriceDetailsAccommodationScalarFieldEnum = {
  id: 'id',
  accommodationId: 'accommodationId',
  roomId: 'roomId',
  pax: 'pax',
  price: 'price',
  priceAfterMarkup: 'priceAfterMarkup',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice',
  quantity: 'quantity',
  totalPrice: 'totalPrice',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup',
  category: 'category'
};

exports.Prisma.NotificationScalarFieldEnum = {
  id: 'id',
  type: 'type',
  title: 'title',
  message: 'message',
  entityType: 'entityType',
  entityId: 'entityId',
  recipientId: 'recipientId',
  isRead: 'isRead',
  createdAt: 'createdAt'
};

exports.Prisma.DocumentScalarFieldEnum = {
  id: 'id',
  name: 'name',
  type: 'type',
  fileUrl: 'fileUrl',
  fileType: 'fileType',
  size: 'size',
  uploadedOn: 'uploadedOn',
  uploadedBy: 'uploadedBy',
  leadId: 'leadId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  bookingId: 'bookingId'
};

exports.Prisma.GuideScalarFieldEnum = {
  id: 'id',
  name: 'name',
  phone: 'phone',
  email: 'email',
  description: 'description',
  termsAndConditions: 'termsAndConditions',
  createdAt: 'createdAt',
  supplierId: 'supplierId',
  updatedAt: 'updatedAt'
};

exports.Prisma.GuidePriceScalarFieldEnum = {
  id: 'id',
  guideId: 'guideId',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice',
  category: 'category',
  paxType: 'paxType'
};

exports.Prisma.TourScalarFieldEnum = {
  id: 'id',
  name: 'name',
  location: 'location',
  description: 'description',
  termsAndConditions: 'termsAndConditions',
  supplierId: 'supplierId'
};

exports.Prisma.TourPriceScalarFieldEnum = {
  id: 'id',
  tourId: 'tourId',
  minNoOfPax: 'minNoOfPax',
  maxNoOfPax: 'maxNoOfPax',
  paxType: 'paxType',
  costPrice: 'costPrice',
  vehicle: 'vehicle',
  optionalPrice: 'optionalPrice'
};

exports.Prisma.BookingScalarFieldEnum = {
  id: 'id',
  reference: 'reference',
  agent: 'agent',
  quotePrice: 'quotePrice',
  actualCost: 'actualCost',
  actualPrice: 'actualPrice',
  profit: 'profit',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  quotationId: 'quotationId',
  travelDates: 'travelDates',
  leadNo: 'leadNo',
  currency: 'currency',
  currencyRate: 'currencyRate',
  termsAndConditions: 'termsAndConditions',
  importantNotes: 'importantNotes',
  guestName: 'guestName'
};

exports.Prisma.BookingAccommodationScalarFieldEnum = {
  id: 'id',
  bookingId: 'bookingId',
  quantity: 'quantity',
  createdAt: 'createdAt',
  endDate: 'endDate',
  hotel: 'hotel',
  nights: 'nights',
  priceDetails: 'priceDetails',
  quotationId: 'quotationId',
  room: 'room',
  surchargeNights: 'surchargeNights',
  travelDate: 'travelDate',
  updatedAt: 'updatedAt',
  profit: 'profit',
  quotePrice: 'quotePrice',
  supplierContact: 'supplierContact',
  supplierId: 'supplierId',
  supplierName: 'supplierName',
  confirmationNo: 'confirmationNo',
  details: 'details',
  actualPrice: 'actualPrice',
  hotelAddress: 'hotelAddress'
};

exports.Prisma.BookingItineraryScalarFieldEnum = {
  id: 'id',
  date: 'date',
  category: 'category',
  bookingId: 'bookingId',
  guideId: 'guideId',
  label: 'label',
  priceDetails: 'priceDetails',
  quotationId: 'quotationId',
  actualPrice: 'actualPrice',
  details: 'details',
  profit: 'profit',
  supplierContact: 'supplierContact',
  supplierId: 'supplierId',
  supplierName: 'supplierName',
  quotePrice: 'quotePrice',
  confirmationNo: 'confirmationNo'
};

exports.Prisma.BookingPriceDetailItineraryScalarFieldEnum = {
  id: 'id',
  itineraryId: 'itineraryId',
  category: 'category',
  price: 'price',
  quantity: 'quantity',
  totalPrice: 'totalPrice',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup',
  quotePrice: 'quotePrice'
};

exports.Prisma.BookingPriceDetailsAccommodationScalarFieldEnum = {
  id: 'id',
  accommodationId: 'accommodationId',
  roomId: 'roomId',
  pax: 'pax',
  price: 'price',
  costPrice: 'costPrice',
  optionalPrice: 'optionalPrice',
  quantity: 'quantity',
  totalPrice: 'totalPrice',
  totalPriceAfterMarkup: 'totalPriceAfterMarkup',
  quotePrice: 'quotePrice',
  category: 'category'
};

exports.Prisma.ServiceScalarFieldEnum = {
  id: 'id',
  bookingId: 'bookingId',
  tourDetailId: 'tourDetailId',
  type: 'type',
  name: 'name',
  quotedPrice: 'quotedPrice',
  actualPrice: 'actualPrice',
  supplierName: 'supplierName',
  supplierContact: 'supplierContact',
  confirmationNo: 'confirmationNo',
  additionalDetails: 'additionalDetails',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.TourDetailScalarFieldEnum = {
  id: 'id',
  quotationId: 'quotationId',
  name: 'name',
  destination: 'destination',
  startDate: 'startDate',
  endDate: 'endDate',
  pax: 'pax',
  profitPercent: 'profitPercent',
  netSellingPrice: 'netSellingPrice',
  totalCost: 'totalCost',
  profitAmount: 'profitAmount',
  bookingId: 'bookingId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.PaymentInvoiceScalarFieldEnum = {
  id: 'id',
  quotationId: 'quotationId',
  bookingId: 'bookingId',
  amount: 'amount',
  status: 'status',
  issuedDate: 'issuedDate',
  dueDate: 'dueDate',
  remarks: 'remarks',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.HotelVoucherScalarFieldEnum = {
  id: 'id',
  voucherNo: 'voucherNo',
  accommodationId: 'accommodationId',
  totalAdults: 'totalAdults',
  totalKids: 'totalKids',
  hotelName: 'hotelName',
  hotelAddress: 'hotelAddress',
  hotelPhone: 'hotelPhone',
  checkInDate: 'checkInDate',
  checkOutDate: 'checkOutDate',
  roomDetails: 'roomDetails',
  mealPlan: 'mealPlan',
  confirmationNumber: 'confirmationNumber',
  specialInclusions: 'specialInclusions',
  termsAndConditions: 'termsAndConditions',
  issuedAt: 'issuedAt',
  customerName: 'customerName',
  bookingId: 'bookingId'
};

exports.Prisma.FinalItineraryItemScalarFieldEnum = {
  id: 'id',
  bookingId: 'bookingId',
  day: 'day',
  activity: 'activity',
  location: 'location',
  time: 'time',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  notes: 'notes',
  sourceId: 'sourceId',
  sourceType: 'sourceType'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};
exports.LeadStage = exports.$Enums.LeadStage = {
  new_lead: 'new_lead',
  quotation_created: 'quotation_created',
  quotation_sent: 'quotation_sent',
  quotation_accepted: 'quotation_accepted',
  quotation_revised: 'quotation_revised',
  assigned_to_operations: 'assigned_to_operations',
  advance_payment: 'advance_payment',
  hotel_booked: 'hotel_booked',
  flight_booked: 'flight_booked',
  itinerary_finalized: 'itinerary_finalized',
  docs_shared: 'docs_shared',
  final_payment: 'final_payment',
  trip_started: 'trip_started',
  trip_completed: 'trip_completed',
  feedback_collected: 'feedback_collected',
  canceled: 'canceled',
  quotation_duplicated: 'quotation_duplicated',
  assigned_to_assessment: 'assigned_to_assessment'
};

exports.LeadStatus = exports.$Enums.LeadStatus = {
  active: 'active',
  closed: 'closed'
};

exports.QuotationStatus = exports.$Enums.QuotationStatus = {
  Draft: 'Draft',
  Sent: 'Sent',
  Accepted: 'Accepted',
  Rejected: 'Rejected',
  Cancelled: 'Cancelled'
};

exports.ServiceType = exports.$Enums.ServiceType = {
  HOTEL: 'HOTEL',
  ATTRACTION: 'ATTRACTION',
  VEHICLE: 'VEHICLE',
  GUIDE: 'GUIDE'
};

exports.Prisma.ModelName = {
  Admin: 'Admin',
  Suppliers: 'Suppliers',
  Hotels: 'Hotels',
  Room: 'Room',
  RoomPrice: 'RoomPrice',
  HotelPrice: 'HotelPrice',
  Vehicle: 'Vehicle',
  Transfer: 'Transfer',
  Attraction: 'Attraction',
  AttractionPrice: 'AttractionPrice',
  User: 'User',
  Team: 'Team',
  AgentCredentials: 'AgentCredentials',
  Agent: 'Agent',
  Lead: 'Lead',
  FollowUp: 'FollowUp',
  Restaurant: 'Restaurant',
  MealPrice: 'MealPrice',
  Package: 'Package',
  Quotation: 'Quotation',
  Accommodation: 'Accommodation',
  Itinerary: 'Itinerary',
  PriceDetailItinerary: 'PriceDetailItinerary',
  PriceDetailsAccommodation: 'PriceDetailsAccommodation',
  Notification: 'Notification',
  Document: 'Document',
  Guide: 'Guide',
  GuidePrice: 'GuidePrice',
  Tour: 'Tour',
  TourPrice: 'TourPrice',
  Booking: 'Booking',
  BookingAccommodation: 'BookingAccommodation',
  BookingItinerary: 'BookingItinerary',
  BookingPriceDetailItinerary: 'BookingPriceDetailItinerary',
  BookingPriceDetailsAccommodation: 'BookingPriceDetailsAccommodation',
  Service: 'Service',
  TourDetail: 'TourDetail',
  PaymentInvoice: 'PaymentInvoice',
  HotelVoucher: 'HotelVoucher',
  FinalItineraryItem: 'FinalItineraryItem'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
