"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSocket = initSocket;
exports.getIO = getIO;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
let ioInstance = null; // Initialize as null
const userSocketMap = {}; // Map user IDs to socket IDs
function initSocket(io) {
    ioInstance = io;
    io.on("connection", (socket) => {
        var _a;
        console.log("🔌 Socket connected:", socket.id);
        const token = (_a = socket.handshake.auth) === null || _a === void 0 ? void 0 : _a.token;
        if (!token) {
            console.log("❌ No token provided, disconnecting socket");
            socket.disconnect();
            return;
        }
        try {
            const decoded = jsonwebtoken_1.default.verify(token, SECRET_KEY);
            if (!decoded || !decoded.userId || !decoded.role) {
                console.log("❌ Invalid token payload, disconnecting socket");
                socket.disconnect();
                return;
            }
            const userId = decoded.userId;
            const role = decoded.role;
            // Store the socket ID associated with the user ID
            userSocketMap[userId] = socket.id;
            console.log(`User ${userId} connected with socket ID: ${socket.id}`);
            // Join the role-based room (e.g., "admin", "agent", "user")
            socket.join(role);
            // Join user-specific room
            socket.join(`user_${userId}`);
            console.log(`✅ Socket ${socket.id} joined rooms: [${role}], [user_${userId}]`);
            socket.on("disconnect", () => {
                delete userSocketMap[userId]; // Remove the mapping on disconnect
                console.log(`🔌 Socket disconnected: ${socket.id}`);
            });
        }
        catch (err) {
            console.error("❌ Socket authentication error:", err);
            socket.disconnect();
        }
    });
}
// To emit notifications anywhere
function getIO() {
    if (!ioInstance)
        throw new Error("Socket.io not initialized");
    return ioInstance;
}
//# sourceMappingURL=socket.js.map