"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuotationService = void 0;
class QuotationService {
    constructor(quotationRepository) {
        this.quotationRepository = quotationRepository;
    }
    async createQuotation(data, userid) {
        try {
            const quotation = await this.quotationRepository.createQuotation(data, userid); // Pass userid
            console.log("Quotation created in service:", quotation);
            return quotation;
        }
        catch (error) {
            console.error("Service error while creating quotation:", error);
            throw error; // Re-throw to be handled by controller
        }
    }
    async getQuotationById(id, userid) {
        try {
            return await this.quotationRepository.getQuotationById(id, userid);
        }
        catch (error) {
            console.error("Service error:", error);
            throw error; // Re-throw for controller to handle
        }
    }
    async getAllQuotations(userid) {
        try {
            const quotations = await this.quotationRepository.getAllQuotations(userid); // Pass userid
            console.log("Quotations fetched successfully:", quotations);
            return quotations;
        }
        catch (error) {
            console.error("Error in QuotationService.getAllQuotations:", error);
            throw new Error("Failed to fetch quotations"); // Better error
        }
    }
    async updateQuotation(id, data, userid) {
        try {
            const response = await this.quotationRepository.updateQuotation(id, data, userid);
            console.log("Response in Service layer update", response);
            return response;
        }
        catch (error) {
            console.error("Service error updating quotation:", error);
            throw error; // Re-throw for handling in controller
        }
    }
    async deleteQuotation(id, userid) {
        try {
            const response = await this.quotationRepository.deleteQuotation(id, userid);
            return response;
        }
        catch (error) {
            console.error("Service error deleting quotation:", error);
            throw error; // Re-throw for controller
        }
    }
    async duplicateQuotation(id, userid) {
        try {
            const response = await this.quotationRepository.duplicateQuotation(id, userid);
            return response;
        }
        catch (error) {
            console.error("Service error duplicating quotation:", error);
            throw error; // Re-throw for controller
        }
    }
    async getQuotationByLeadRefNo(leadRefNo) {
        try {
            const response = await this.quotationRepository.getQuotationByLeadRefNo(leadRefNo);
            return response;
        }
        catch (error) {
            console.error("Service error getting quotation by lead ref no:", error);
            throw error; // Re-throw for controller
        }
    }
    async getAcceptedQuotationsByLeadId(leadId, userid) {
        try {
            const response = await this.quotationRepository.getAcceptedQuotationsByLeadId(leadId, userid);
            return response;
        }
        catch (error) {
            console.error("Service error getting accepted quotations by lead id:", error);
            throw error; // Re-throw for controller
        }
    }
    async updateQuotationStatus(id, status, userId) {
        try {
            const updated = await this.quotationRepository.updateQuotationStatus(id, status, userId); // Pass userId to repository
            return updated;
        }
        catch (error) {
            console.error("Service: Failed to update status", error);
            throw error;
        }
    }
}
exports.QuotationService = QuotationService;
//# sourceMappingURL=userquotationService.js.map