import { QuotationStatus } from '@prisma/client';
import { QuotationRepository } from '../../repositories/user/userquotationRepository';
export declare class QuotationService {
    private quotationRepository;
    constructor(quotationRepository: QuotationRepository);
    createQuotation(data: any, userid: string): Promise<{
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: import("@prisma/client/runtime/library").Decimal | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
        totalBeforeMarkup: import("@prisma/client/runtime/library").Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
    getQuotationById(id: string, userid: string): Promise<any>;
    getAllQuotations(userid: string): Promise<any[]>;
    updateQuotation(id: string, data: any, userid: string): Promise<any>;
    deleteQuotation(id: string, userid: string): Promise<any>;
    duplicateQuotation(id: string, userid: string): Promise<any>;
    getQuotationByLeadRefNo(leadRefNo: string): Promise<any>;
    getAcceptedQuotationsByLeadId(leadId: string, userid: string): Promise<any>;
    updateQuotationStatus(id: string, status: QuotationStatus, userId: string): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: import("@prisma/client/runtime/library").Decimal | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            itinMarkup: number | null;
        })[];
        tours: {
            id: string;
            name: string;
            description: string | null;
            supplierId: string | null;
            location: string | null;
            termsAndConditions: string | null;
        }[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
        totalBeforeMarkup: import("@prisma/client/runtime/library").Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }>;
}
//# sourceMappingURL=userquotationService.d.ts.map