"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const userRepository_1 = require("../../repositories/user/userRepository");
const userRepository = new userRepository_1.UserRepository();
class UserService {
    async createUser(data) {
        return await userRepository.createUser(data);
    }
    async getUsers() {
        return await userRepository.getUsers();
    }
    async getUserById(id) {
        return await userRepository.getUserById(id);
    }
    async getUserByEmail(email) {
        return await userRepository.getUserByEmail(email);
    }
    async updateUser(id, data) {
        return await userRepository.updateUser(id, data);
    }
    async deleteUser(id) {
        return await userRepository.deleteUser(id);
    }
    async restore(id) {
        return await userRepository.restore(id);
    }
    async deleteUserPermanently(id) {
        return await userRepository.deleteUserPermanently(id);
    }
    async getInactiveUsers() {
        return await userRepository.getInactiveUsers();
    }
    async getUsersByTeamId(teamId) {
        return await userRepository.getUsersByTeamId(teamId);
    }
    async searchUsers(searchTerm) {
        return await userRepository.searchUsers(searchTerm);
    }
}
exports.UserService = UserService;
//# sourceMappingURL=userService.js.map