"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.userLogin = void 0;
const dotenv_1 = __importDefault(require("dotenv"));
const bcrypt_1 = __importDefault(require("bcrypt"));
const UserRepository = __importStar(require("../../repositories/user/userLoginRepository"));
const generateJwt_1 = require("../../utils/generateJwt");
// Load environment variables
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET;
const userLogin = async ({ email, password, }) => {
    console.log("Email in service", email);
    const user = await UserRepository.getUserByEmail(email);
    if (!user) {
        throw {
            status: 404,
            message: "User not found with the given email.",
        };
    }
    if (user.inactive == true) {
        throw {
            status: 403,
            message: "This account has been deactivated.",
        };
    }
    if (!user.password)
        throw new Error("User password is missing");
    const passwordMatch = await bcrypt_1.default.compare(password, user.password);
    console.log(password, user.password);
    if (!passwordMatch)
        throw new Error("Invalid credentials");
    console.log(" user details ", user);
    if (!user.teamId)
        throw new Error("User role is missing");
    console.log("user.teamId", user.teamId);
    // Generate access and refresh tokens
    const accessToken = (0, generateJwt_1.generateToken)(user.id.toString(), user.role, SECRET_KEY, "7d", user.teamId);
    const refreshToken = (0, generateJwt_1.generateToken)(user.id.toString(), user.role, REFRESH_SECRET, "14d", user.teamId);
    console.log("Generated Tokens:", { accessToken, refreshToken });
    return { accessToken, refreshToken, user };
};
exports.userLogin = userLogin;
//# sourceMappingURL=userLoginService.js.map