"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAssessmentService = void 0;
class UserAssessmentService {
    constructor(userAssessmentRepository) {
        this.userAssessmentRepository = userAssessmentRepository;
    }
    async getAllAssessments(userId) {
        try {
            return await this.userAssessmentRepository.getAllAssessments(userId);
        }
        catch (error) {
            console.error("Error fetching all assessments:", error);
            throw new Error("Failed to retrieve assessments");
        }
    }
    async getAssessmentById(id) {
        try {
            return await this.userAssessmentRepository.getAssessmentById(id);
        }
        catch (error) {
            console.error("Error fetching assessment by ID:", error);
            throw new Error("Failed to retrieve assessment");
        }
    }
}
exports.UserAssessmentService = UserAssessmentService;
//# sourceMappingURL=userAssessmentService.js.map