"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationDashboardService = void 0;
const operationDashboardRepository_1 = require("../../repositories/user/operationDashboardRepository");
class OperationDashboardService {
    constructor() {
        this.operationDashboardRepository = new operationDashboardRepository_1.OperationDashboardRepository();
    }
    async getDashboardData(userId) {
        try {
            const data = await this.operationDashboardRepository.getDashboardData(userId); // Pass userId to repository
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Service failed to fetch Operation dashboard data");
        }
    }
    async getTopBookings(userId, limit = 5) {
        try {
            const data = await this.operationDashboardRepository.getTopBookingsByProfit(userId, limit); // Pass userId to repository
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Failed to fetch Top 5 Bookings");
        }
    }
    async getBookingLeadOverview(timeframe = "weekly", userId) {
        try {
            const data = await this.operationDashboardRepository.getBookingLeadOverview(timeframe, userId); // Pass userId to repository
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Failed to fetch booking leads data");
        }
    }
}
exports.OperationDashboardService = OperationDashboardService;
//# sourceMappingURL=operationDashboardService.js.map