"use strict";
// File: backend/src/services/user/documentService.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentService = void 0;
class DocumentService {
    constructor(documentRepository) {
        this.documentRepository = documentRepository;
    }
    async createDocument(documentData) {
        try {
            return await this.documentRepository.createDocument(documentData);
        }
        catch (error) {
            console.error('Error creating document in service:', error);
            throw error;
        }
    }
    async getDocumentsForLead(leadId) {
        try {
            return await this.documentRepository.getDocumentsForLead(leadId);
        }
        catch (error) {
            console.error('Error getting documents for lead in service:', error);
            throw error;
        }
    }
    async deleteDocument(documentId) {
        try {
            await this.documentRepository.deleteDocument(documentId);
        }
        catch (error) {
            console.error('Error deleting document in service:', error);
            throw error;
        }
    }
}
exports.DocumentService = DocumentService;
//# sourceMappingURL=documentService.js.map