"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssessmentDashboardService = void 0;
const assessmentDashboardRepository_1 = require("../../repositories/user/assessmentDashboardRepository");
class AssessmentDashboardService {
    constructor() {
        this.assessmentDashboardRepository = new assessmentDashboardRepository_1.AssessmentDashboardRepository();
    }
    async getDashboardData(userId) {
        try {
            const data = await this.assessmentDashboardRepository.getDashboardData(userId);
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Service failed to fetch Assessment dashboard data");
        }
    }
    async getAssessmentLeadOverview(timeframe = "weekly", userId) {
        try {
            const data = await this.assessmentDashboardRepository.getAssessmentLeadOverview(timeframe, userId);
            return data;
        }
        catch (error) {
            console.error("Service Error:", error);
            throw new Error("Failed to fetch booking leads data");
        }
    }
}
exports.AssessmentDashboardService = AssessmentDashboardService;
//# sourceMappingURL=assessmentDashboardService.js.map