"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDashboardService = void 0;
// services/UserDashboardService.ts
const UserTeamDashboardRepository_1 = require("../../repositories/user/UserTeamDashboardRepository");
class UserDashboardService {
    constructor() {
        this.dashboardRepository = new UserTeamDashboardRepository_1.UserTeamDashboardRepository();
    }
    async getDashboardData(teamId, leadPersonEmpCode) {
        try {
            return await this.dashboardRepository.getDashboardData(teamId, leadPersonEmpCode);
        }
        catch (error) {
            console.error("Service Error - getDashboardData:", error);
            throw new Error("Service failed to fetch user dashboard data");
        }
    }
}
exports.UserDashboardService = UserDashboardService;
//# sourceMappingURL=UserTeamDashboardService.js.map