export declare class UserDashboardService {
    private dashboardRepository;
    constructor();
    getDashboardData(teamId: string, leadPersonEmpCode: string): Promise<{
        totalLeads: number;
        bookedLeads: number;
        newLeads: never[];
        agentCount: number;
        leadPersonName: null;
        cancelledLeads: number;
        dataSeries: {
            agents: never[];
            leads: never[];
            totalQuotationsCreated: number;
            bookings: never[];
        };
        totalQuotationsCreated?: undefined;
    } | {
        totalLeads: number;
        bookedLeads: number;
        newLeads: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        }[];
        totalQuotationsCreated: number;
        agentCount: number;
        leadPersonName: string;
        cancelledLeads: number;
        dataSeries: {
            agents: any[];
            leads: any[];
            bookings: number[];
            totalQuotationsCreated?: undefined;
        };
    }>;
}
//# sourceMappingURL=UserTeamDashboardService.d.ts.map