"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserLeadService = void 0;
class UserLeadService {
    constructor(userLeadRepository) {
        this.userLeadRepository = userLeadRepository;
    }
    async createLead(leadData) {
        try {
            const newLead = await this.userLeadRepository.createLead(leadData);
            console.log("New lead created:", newLead);
            return newLead;
        }
        catch (error) {
            console.error("Error creating lead in user service:", error);
            throw error;
        }
    }
    async getUserLeads(userId) {
        try {
            return await this.userLeadRepository.getUserLeadsByUserId(userId);
        }
        catch (error) {
            console.error("Error in getUserLeads (service):", error);
            throw error;
        }
    }
    async getLeadById(leadId) {
        try {
            const lead = await this.userLeadRepository.getLeadById(leadId);
            return lead;
        }
        catch (error) {
            console.error("Error getting lead by ID in user service:", error);
            throw error;
        }
    }
    async updateLead(leadId, leadData) {
        try {
            const updatedLead = await this.userLeadRepository.updateLead(leadId, leadData);
            return updatedLead;
        }
        catch (error) {
            console.error("Error updating lead in user service:", error);
            throw error;
        }
    }
    async deleteLead(leadId) {
        try {
            await this.userLeadRepository.deleteLead(leadId);
        }
        catch (error) {
            console.error("Error deleting lead in user service:", error);
            throw error;
        }
    }
    async changeStatus(id, status) {
        return await this.userLeadRepository.updateLeadStatus(id, status);
    }
    async changeStage(id, stage, userName, notes) {
        return await this.userLeadRepository.updateLeadStage(id, stage, userName, notes);
    }
}
exports.UserLeadService = UserLeadService;
//# sourceMappingURL=UserLeadService.js.map