import { LeadStage, LeadStatus } from "@prisma/client";
import { Lead } from "../../interfaces/Lead";
import { UserLeadRepository } from "../../repositories/user/userLeadRepository";
export declare class UserLeadService {
    private userLeadRepository;
    constructor(userLeadRepository: UserLeadRepository);
    createLead(leadData: Lead): Promise<Lead>;
    getUserLeads(userId: string): Promise<Lead[]>;
    getLeadById(leadId: string): Promise<Lead | null>;
    updateLead(leadId: string, leadData: Partial<Lead>): Promise<Lead | null>;
    deleteLead(leadId: string): Promise<void>;
    changeStatus(id: string, status: LeadStatus): Promise<Lead | null>;
    changeStage(id: string, stage: LeadStage, userName?: string, notes?: string): Promise<Lead | null>;
}
//# sourceMappingURL=UserLeadService.d.ts.map