import { BookingRepository } from "../../repositories/user/UserbookingRepository";
import { LeadStatus, LeadStage, BookingPriceDetailsAccommodation } from '@prisma/client';
export declare class BookingService {
    private bookingRepository;
    constructor(bookingRepository?: BookingRepository);
    fetchQuotationWithDetails(quotationId: string): Promise<({
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        };
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            hotelAddress: string | null;
            totalPrice: import("@prisma/client/runtime/library").Decimal | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            accMarkup: number | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
                priceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            itinMarkup: number | null;
        })[];
    } & {
        id: string;
        totalPax: number | null;
        remarks: string | null;
        agentId: string | null;
        status: import(".prisma/client").$Enums.QuotationStatus;
        updatedAt: Date;
        termsAndConditions: string | null;
        refNo: string;
        leadAgent: string;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        leadRefNo: string;
        totalAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
        totalBeforeMarkup: import("@prisma/client/runtime/library").Decimal | null;
        userid: string | null;
        currencyRate: number | null;
        importantNotes: string | null;
    }) | null>;
    createBookingFromQuotation(quotationId: string): Promise<{
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }>;
    getAllBookings(userId: string): Promise<({
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    })[]>;
    getBookingById(id: string): Promise<{
        lead: ({
            Agent: {
                id: string;
                email: string | null;
                role: string | null;
                createdAt: Date | null;
                agentCode: string | null;
                phone: string | null;
                updatedAt: Date | null;
                agentPrivilege: boolean | null;
                companyName: string | null;
                contactPerson: string | null;
                designation: string | null;
                companyAddress: string | null;
                deleted: boolean | null;
                state: string | null;
                markup: number | null;
                credentialsId: string | null;
            } | null;
        } & {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        }) | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }>;
    updateBookingStatus(bookingId: string, status: LeadStatus, userName: string): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }>;
    updateBookingStage(bookingId: string, stage: LeadStage, notes: string, userName: string): Promise<{
        lead: {
            id: string;
            email: string | null;
            userId: string | null;
            createdOn: Date;
            empCode: string | null;
            agentName: string | null;
            agentCode: string | null;
            leadNo: string;
            travelDateFrom: Date | null;
            travelDateTo: Date | null;
            totalPax: number | null;
            description: string | null;
            customerName: string | null;
            phone: string | null;
            adults: number | null;
            kids: number | null;
            infants: number | null;
            remarks: string | null;
            agentId: string | null;
            stage: import(".prisma/client").$Enums.LeadStage;
            status: import(".prisma/client").$Enums.LeadStatus;
            statusUpdated: Date | null;
            updatedAt: Date | null;
            assignedToId: string | null;
            assignedOperationId: string | null;
            assignedAssessmentId: string | null;
            assignedAssessmentOn: Date | null;
            assignedOperationOn: Date | null;
        } | null;
        accommodations: ({
            priceDetailsAccommodation: {
                id: string;
                category: string | null;
                costPrice: import("@prisma/client/runtime/library").Decimal | null;
                optionalPrice: import("@prisma/client/runtime/library").Decimal | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                pax: string | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                accommodationId: string | null;
                roomId: string | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
            }[];
        } & {
            id: string;
            createdAt: Date;
            updatedAt: Date;
            supplierId: string | null;
            hotel: string | null;
            room: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            quantity: number | null;
            endDate: Date | null;
            nights: number | null;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            surchargeNights: number | null;
            travelDate: Date | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            hotelAddress: string | null;
            bookingId: string | null;
        })[];
        itineraries: ({
            priceDetailsList: {
                id: string;
                category: string | null;
                price: import("@prisma/client/runtime/library").Decimal | null;
                quotePrice: import("@prisma/client/runtime/library").Decimal | null;
                quantity: number | null;
                totalPrice: import("@prisma/client/runtime/library").Decimal | null;
                totalPriceAfterMarkup: import("@prisma/client/runtime/library").Decimal | null;
                itineraryId: string | null;
            }[];
        } & {
            id: string;
            supplierId: string | null;
            category: string | null;
            quotePrice: import("@prisma/client/runtime/library").Decimal | null;
            actualPrice: import("@prisma/client/runtime/library").Decimal | null;
            profit: import("@prisma/client/runtime/library").Decimal | null;
            quotationId: string;
            priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
            supplierContact: string | null;
            supplierName: string | null;
            confirmationNo: string | null;
            details: string | null;
            date: Date | null;
            label: string | null;
            guideId: string | null;
            bookingId: string | null;
        })[];
    } & {
        agent: string;
        id: string;
        createdAt: Date;
        leadNo: string | null;
        updatedAt: Date;
        termsAndConditions: string | null;
        guestName: string | null;
        currency: string | null;
        travelDates: string;
        currencyRate: number | null;
        importantNotes: string | null;
        reference: string;
        quotePrice: number;
        actualCost: number;
        actualPrice: number;
        profit: number;
        quotationId: string;
    }>;
    updateAccommodationInBooking(bookingId: string, accommodationId: string, updateData: {
        hotel?: string;
        room?: string;
        supplierName?: string;
        supplierContact?: string;
        travelDate?: string;
        nights?: number;
        quotePrice?: number | null;
        actualPrice?: number | null;
        confirmationNo?: string;
        details?: string;
        quantity?: number;
        priceDetailsAccommodation?: BookingPriceDetailsAccommodation[];
    }): Promise<{
        id: string;
        createdAt: Date;
        updatedAt: Date;
        supplierId: string | null;
        hotel: string | null;
        room: string | null;
        quotePrice: import("@prisma/client/runtime/library").Decimal | null;
        actualPrice: import("@prisma/client/runtime/library").Decimal | null;
        profit: import("@prisma/client/runtime/library").Decimal | null;
        quotationId: string;
        quantity: number | null;
        endDate: Date | null;
        nights: number | null;
        priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
        surchargeNights: number | null;
        travelDate: Date | null;
        supplierContact: string | null;
        supplierName: string | null;
        confirmationNo: string | null;
        details: string | null;
        hotelAddress: string | null;
        bookingId: string | null;
    }>;
    updateItinerary(bookingId: string, itineraryId: string, updateData: {
        date?: string;
        label?: string;
        category?: string;
        quotedPrice?: number | null;
        actualPrice?: number | null;
        supplierId?: string;
        supplierName?: string;
        supplierContact?: string;
        confirmationNo?: string;
        details?: string;
        quantity?: number;
        priceDetailsList?: any[];
    }): Promise<{
        id: string;
        supplierId: string | null;
        category: string | null;
        quotePrice: import("@prisma/client/runtime/library").Decimal | null;
        actualPrice: import("@prisma/client/runtime/library").Decimal | null;
        profit: import("@prisma/client/runtime/library").Decimal | null;
        quotationId: string;
        priceDetails: import("@prisma/client/runtime/library").JsonValue | null;
        supplierContact: string | null;
        supplierName: string | null;
        confirmationNo: string | null;
        details: string | null;
        date: Date | null;
        label: string | null;
        guideId: string | null;
        bookingId: string | null;
    }>;
}
//# sourceMappingURL=UserBookingService.d.ts.map