"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeadService = void 0;
const leadRepository_1 = require("../repositories/leadRepository");
class LeadService {
    constructor() {
        this.leadRepository = new leadRepository_1.LeadRepository();
    }
    async createLead(data) {
        try {
            return await this.leadRepository.createLead(data);
        }
        catch (error) {
            console.error("Error creating lead in service:", error);
            throw new Error(error.message || "Error creating lead");
        }
    }
    async getLeads() {
        return await this.leadRepository.getLeads();
    }
    async getLeadById(id) {
        return await this.leadRepository.getLeadById(id);
    }
    async updateLead(id, data) {
        return await this.leadRepository.updateLead(id, data);
    }
    async deleteLead(id) {
        return await this.leadRepository.deleteLead(id);
    }
}
exports.LeadService = LeadService;
//# sourceMappingURL=leadService.js.map