"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelService = void 0;
const hotelRepository_1 = require("../repositories/hotelRepository");
class HotelService {
    constructor() {
        this.hotelRepository = new hotelRepository_1.HotelRepository();
    }
    createHotel(data) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.hotelRepository.createHotel(data);
        });
    }
    getHotels() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.hotelRepository.getHotels();
        });
    }
    getHotelById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.hotelRepository.getHotelById(id);
        });
    }
    updateHotel(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.hotelRepository.updateHotel(id, data);
        });
    }
    deleteHotel(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.hotelRepository.deleteHotel(id);
        });
    }
}
exports.HotelService = HotelService;
