"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationService = void 0;
// src/services/notification.service.ts
const prismaClient_1 = __importDefault(require("../../config/prismaClient"));
const socket_1 = require("../../socket/socket");
class NotificationService {
    constructor() {
        this.userRoom = (userId) => `user_${userId}`;
    }
    /** Send user notification */
    async notifyUser(userId, dto) {
        return this.saveAndEmit({ ...dto, recipientId: userId }, this.userRoom(userId));
    }
    async notifyAdmin(dto) {
        return this.saveAndEmit({ ...dto, recipientId: "admin" }, "admin");
    }
    async saveAndEmit(data, room) {
        const io = (0, socket_1.getIO)(); // ✅ fetch it inside method
        const notification = await prismaClient_1.default.notification.create({ data });
        io.to(room).emit("receive_notification", {
            ...data,
            createdAt: notification.createdAt,
        });
        console.log(`📨 emitted to [${room}]`, {
            type: data.type,
            title: data.title,
        });
        return notification;
    }
    getAdminNotifications() {
        return prismaClient_1.default.notification.findMany({
            where: { recipientId: "admin" },
            orderBy: { createdAt: "desc" },
        });
    }
    getUserNotifications(userId) {
        return prismaClient_1.default.notification.findMany({
            where: { recipientId: userId },
            orderBy: { createdAt: "desc" },
        });
    }
    markAsRead(id) {
        return prismaClient_1.default.notification.update({ where: { id }, data: { isRead: true } });
    }
    markAllAsReadForAdmin() {
        return prismaClient_1.default.notification.updateMany({
            where: { recipientId: "admin", isRead: false },
            data: { isRead: true }
        });
    }
}
exports.NotificationService = NotificationService;
//# sourceMappingURL=notificationService.js.map