/** Payload for a new notification */
interface CreateNotificationDto {
    type: string;
    title: string;
    message: string;
    entityType: string;
    entityId: string;
    /** "admin" for super-admin broadcast OR the userId of the recipient */
    recipientId: string;
}
export declare class NotificationService {
    private userRoom;
    /** Send user notification */
    notifyUser(userId: string, dto: Omit<CreateNotificationDto, "recipientId">): Promise<{
        id: string;
        createdAt: Date;
        recipientId: string;
        type: string;
        title: string;
        message: string;
        entityType: string;
        entityId: string;
        isRead: boolean;
    }>;
    notifyAdmin(dto: Omit<CreateNotificationDto, "recipientId">): Promise<{
        id: string;
        createdAt: Date;
        recipientId: string;
        type: string;
        title: string;
        message: string;
        entityType: string;
        entityId: string;
        isRead: boolean;
    }>;
    private saveAndEmit;
    getAdminNotifications(): import(".prisma/client").Prisma.PrismaPromise<{
        id: string;
        createdAt: Date;
        recipientId: string;
        type: string;
        title: string;
        message: string;
        entityType: string;
        entityId: string;
        isRead: boolean;
    }[]>;
    getUserNotifications(userId: string): import(".prisma/client").Prisma.PrismaPromise<{
        id: string;
        createdAt: Date;
        recipientId: string;
        type: string;
        title: string;
        message: string;
        entityType: string;
        entityId: string;
        isRead: boolean;
    }[]>;
    markAsRead(id: string): import(".prisma/client").Prisma.Prisma__NotificationClient<{
        id: string;
        createdAt: Date;
        recipientId: string;
        type: string;
        title: string;
        message: string;
        entityType: string;
        entityId: string;
        isRead: boolean;
    }, never, import("@prisma/client/runtime/library").DefaultArgs, import(".prisma/client").Prisma.PrismaClientOptions>;
    markAllAsReadForAdmin(): import(".prisma/client").Prisma.PrismaPromise<import(".prisma/client").Prisma.BatchPayload>;
}
export {};
//# sourceMappingURL=notificationService.d.ts.map