import { Agent, AgentCredentials } from "../../interfaces/Agent";
import { AgentRepository } from "../../repositories/agent/agentRepository";
export declare class agentService {
    private agentRepository;
    constructor(agentRepository: AgentRepository);
    createAgent(agentData: Agent, credentialsData?: AgentCredentials): Promise<Agent>;
    updateAgent(agentId: string, agentData: Partial<Agent>, credentialsData?: Partial<AgentCredentials>): Promise<Agent | null>;
    getAllAgents(): Promise<Agent[]>;
    softDeleteAgent(agentId: string): Promise<Agent | null>;
    restoreAgent(agentId: string): Promise<Agent | null>;
    deleteAgent(agentId: string): Promise<Agent | null>;
}
//# sourceMappingURL=agentService.d.ts.map