"use strict";
// backend/src/services/agent/agentLoginService.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.agentLogin = void 0;
const bcrypt_1 = __importDefault(require("bcrypt"));
const dotenv_1 = __importDefault(require("dotenv"));
const agentLoginRepository_1 = require("../../repositories/agent/agentLoginRepository");
const generateJwt_1 = require("../../utils/generateJwt");
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET;
const agentRepo = new agentLoginRepository_1.AgentLoginRepository();
const agentLogin = async ({ username, password, }) => {
    try {
        console.log("Login attempt for username:", username); // Log username
        const credentials = await agentRepo.getAgentByUsername(username);
        console.log("Agent credentials in service:", credentials); // Log credentials
        if (!credentials || !credentials.agent) {
            console.log("Agent not found for username:", username);
            throw {
                status: 404,
                message: "Agent not found with the given username.",
            };
        }
        const agent = credentials.agent;
        console.log("Agent in service", agent);
        // *** Add this check ***
        if (agent.deleted === true) {
            console.log("Account deactivated:", username);
            throw {
                status: 403, // Or another appropriate status code (e.g., 401)
                message: "This account has been deactivated.",
            };
        }
        if (!agent.agentPrivilege) {
            console.log("Agent lacks privileges:", username);
            throw {
                status: 403,
                message: "Access denied. Agent does not have panel privileges.",
            };
        }
        // ✅ Use bcrypt to compare hashed password
        if (!credentials.password) {
            console.log("Password missing:", username);
            throw {
                status: 400,
                message: "Password is missing for the given agent.",
            };
        }
        const isPasswordValid = await bcrypt_1.default.compare(password, credentials.password);
        console.log("Password comparison result:", isPasswordValid); // Log comparison result
        if (!isPasswordValid) {
            console.log("Invalid password for username:", username);
            throw {
                status: 401,
                message: "Invalid credentials. Please check your password.",
            };
        }
        const accessToken = (0, generateJwt_1.generateToken)(agent.id, agent.role, SECRET_KEY, "7d");
        const refreshToken = (0, generateJwt_1.generateToken)(agent.id, agent.role, REFRESH_SECRET, "14d");
        return {
            accessToken,
            refreshToken,
            credentials,
        };
    }
    catch (error) {
        console.error("Error during login:", error);
        throw error; // Re-throw the error for the controller to handle
    }
};
exports.agentLogin = agentLogin;
//# sourceMappingURL=agentLoginService.js.map